/*
 * SimpleCRC.h
 *
 *  Created on: 2 нояб. 2020 г.
 *      Author: Litvin
 *      2020.10.29_17:57 -- ver. 1.0.0.0 - Creating SimpleCRC class and CalculateOneByteXorCRC method.
 *		2020.11.02_15:00 -- ver. 1.0.1.0 - Add CheckOneByteXorCRC method.
 */

#ifndef INC_SD1_4_300_COMMANDS_CRC_SIMPLECRC_H_
#define INC_SD1_4_300_COMMANDS_CRC_SIMPLECRC_H_

#ifdef ARDUINO
	#include <Arduino.h>
#else
	#include "main.h"
#endif

/// <summary>
/// ver. 1.0.1.0. Class to calculating CRC Checksum
/// </summary>
class Simple_CRC
{

public:

	/// <summary>
	/// Return 1 byte CRC checksum
	/// </summary>
	/// <param name="buff">Pointer to array</param>
	/// <param name="size">Array size</param>
	/// <returns>Returns CRC</returns>
	static uint8_t CalculateOneByteXorCRC(uint8_t* data, size_t len);

	/// <summary>
	/// Checked 1 byte checksum
	/// </summary>
	/// <param name="buff">Pointer to array</param>
	/// <param name="size">Array size</param>
	/// <param name="crc">checked crc</param>
	/// <returns>Returns true if checking passed, otherwise - false</returns>
	static bool CheckOneByteXorCRC(uint8_t* buff, uint8_t size, uint8_t crc);
};

#endif /* INC_SD1_4_300_COMMANDS_CRC_SIMPLECRC_H_ */
