/*
 * SimpleCRC.cpp
 *
 *  Created on: 2 нояб. 2020 г.
 *      Author: Litvin
 */

#include "SimpleCRC.h"

/// <summary>
/// Return 1 byte CRC checksum
/// </summary>
/// <param name="buff">Pointer to array</param>
/// <param name="size">Array size</param>
/// <returns>Returns CRC</returns>
uint8_t Simple_CRC::CalculateOneByteXorCRC(uint8_t* data, size_t len)
{
	uint8_t crc = 0x00;
	size_t i, j;
	for (i = 0; i < len; i++) {
		crc ^= data[i];
		for (j = 0; j < 8; j++) {
			if ((crc & 0x80) != 0)
				crc = (uint8_t)((crc << 1) ^ 0x07);
			else
				crc <<= 1;
		}
	}
	return crc;
}

/// <summary>
/// Checked 1 byte checksum
/// </summary>
/// <param name="buff">Pointer to array</param>
/// <param name="size">Array size</param>
/// <param name="crc">checked crc</param>
/// <returns>Returns true if checking passed, otherwise - false</returns>
bool Simple_CRC::CheckOneByteXorCRC(uint8_t* buff, uint8_t size, uint8_t crc)
{
	uint8_t _crc = CalculateOneByteXorCRC(buff, size);
	return _crc == crc;
};
